/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.event;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import tcintegrations.items.modifiers.hooks.IArmorCrouchModifier;
import tcintegrations.items.modifiers.hooks.IArmorJumpModifier;

@Mod.EventBusSubscriber(modid="tcintegrations", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolEventHandler {
    @SubscribeEvent
    static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack helmet;
        LivingEntity living = event.getEntityLiving();
        if (!living.m_5833_() && !living.f_19853_.m_5776_() && living.m_6084_() && !(helmet = living.m_6844_(EquipmentSlot.HEAD)).m_41619_() && helmet.m_204117_(TinkerTags.Items.HELMETS)) {
            ToolStack tool = ToolStack.from((ItemStack)helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorCrouchModifier crouchModifier = (IArmorCrouchModifier)entry.getModifier().getModule(IArmorCrouchModifier.class);
                if (crouchModifier == null) continue;
                if (living.m_6047_() || living.m_6067_()) {
                    crouchModifier.onCrouch((IToolStackView)tool, entry.getLevel(), living);
                    continue;
                }
                crouchModifier.onStand(living);
            }
        }
    }

    @SubscribeEvent
    static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        ItemStack boots;
        LivingEntity living = event.getEntityLiving();
        if (!living.m_5833_() && !living.f_19853_.m_5776_() && living.m_6084_() && !(boots = living.m_6844_(EquipmentSlot.FEET)).m_41619_() && boots.m_204117_(TinkerTags.Items.BOOTS)) {
            ToolStack tool = ToolStack.from((ItemStack)boots);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorJumpModifier jumpModifier = (IArmorJumpModifier)entry.getModifier().getModule(IArmorJumpModifier.class);
                if (jumpModifier == null) continue;
                jumpModifier.onJump((IToolStackView)tool, living);
            }
        }
    }
}

